// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "IdealTwinSettingItem.h"
#include "IdealTwinSettingDropdown.generated.h"


class UComboBoxString;

UENUM(BlueprintType)
enum ESettingTypeDropdown
{
	ESTD_General			UMETA(DisplayName="General"),
	ESTD_Resolution			UMETA(DisplayName="Resolution"),
	ESTD_Shadow				UMETA(DisplayName="Shadow"),
	ESTD_Shading			UMETA(DisplayName="Shading"),
	ESTD_Foliage			UMETA(DisplayName="Foliage"),
	ESTD_Texture			UMETA(DisplayName="Texture"),
	ESTD_Reflection			UMETA(DisplayName="Reflection"),
	ESTD_AA					UMETA(DisplayName="Anti Aliasing"),
	ESTD_Audio				UMETA(DisplayName="Audio"),
	ESTD_VFX				UMETA(DisplayName="Visual Effect"),
	ESTD_GIllumination		UMETA(DisplayName="Global Ilumination"),
	ESTD_PostProcess		UMETA(DisplayName="Post Process"),
	ESTD_ViewDistance		UMETA(DisplayName="View Distance"),
};
/**
 * 
 */
UCLASS(Abstract)
class IDEALTWINPROUI_API UIdealTwinSettingDropdown : public UIdealTwinSettingItem
{
	GENERATED_BODY()
public:
	UIdealTwinSettingDropdown(const FObjectInitializer& ObjectInitializer);
	
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinSettingDropdown", meta=(ExposeOnSpawn))
	TEnumAsByte<ESettingTypeDropdown> SettingType;
	UPROPERTY(meta=(BindWidget))
	TObjectPtr<UComboBoxString> SettingWidget;

	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinSettingDropdown", meta=(EditCondition="SettingType!=ESettingTypeDropdown::ESTD_Resolution" ,EditConditionHides))
	TMap<int32,FText> OptionsToDisplay;

	void FillUpOptions();

	UFUNCTION(BlueprintNativeEvent,Category="IdealTwinSettingDropdown")
	FString GetResolutionFormatString(FIntPoint InValueRes); 

	virtual void LoadSetting_Implementation() override;
	virtual void RefreshSetting_Implementation() override;
	virtual void ApplySetting_Implementation() override;
	virtual void SetSetting_Implementation() override;
protected:
	virtual void NativeOnInitialized() override;
	virtual void NativeConstruct() override;

	FIntPoint GetResolutionFromSelection();
	
	int32 GetValueFromSetting(const FString& InValue)const;
	
	UFUNCTION() void ReceivedSettingChange(FString SelectedItem, ESelectInfo::Type SelectionType);

private:
	TArray<FIntPoint> ResolutionListValues;
};
