// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "UObject/Object.h"
#include "IdealTwinSettingGeneral.generated.h"


class UIdealTwinSettingItem;
class UITwButton;

UENUM()
enum ESettingApplyType
{
	ESAT_Confirmation		UMETA(DisplayName = "Confirmation"),
	ESAT_AutoApply		UMETA(DisplayName = "Auto Apply"),
	ESAT_Custom		UMETA(DisplayName = "Custom Apply"),
};

UCLASS()
class IDEALTWINPROUI_API UIdealTwinSettingGeneral : public UUserWidget
{
	GENERATED_BODY()
public:
	UIdealTwinSettingGeneral(const FObjectInitializer& ObjectInitializer);

	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="IdealTwinSettingGeneral")
	TEnumAsByte<ESettingApplyType> SettingsApplyType;

	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="IdealTwinSettingGeneral", meta=(BindWidgetOptional))
	TObjectPtr<UITwButton> Btn_ApplyConfirmation;

	UFUNCTION(BlueprintCallable,Category="IdealTwinSettingGeneral")
	void ApplySettings();
	
	UFUNCTION(BlueprintCallable,Category="IdealTwinSettingGeneral")
	bool IsSettingsMarkAsDirty()const;
	UFUNCTION(BlueprintCallable,Category="IdealTwinSettingGeneral")
	bool ApplySettingsIfMarkedAsDirty();

	
	UFUNCTION(BlueprintCallable,Category="IdealTwinSettingGeneral")
	void MarkSettingsAsDirty();

	UFUNCTION(BlueprintCallable,Category="IdealTwinSettingGeneral")
	void RefreshChildrenSettingsItems();
	
protected:

	UFUNCTION() void ReceivedSettingItemDirty(UIdealTwinSettingItem* Item);
	UFUNCTION() void ReceivedApplyConfirmation(FName InId);
	
	virtual void NativeOnInitialized() override;
	virtual void NativeConstruct() override;

private:
	TArray<UIdealTwinSettingItem*> SettingItems;
	bool bMarkedDirtySettings;
};
