// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "UObject/Object.h"
#include "IdealTwinSettingItem.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnSettingItemDirty, UIdealTwinSettingItem*, ItemReference);

UCLASS(Abstract)
class IDEALTWINPROUI_API UIdealTwinSettingItem : public UUserWidget
{
	GENERATED_BODY()
public:
	UIdealTwinSettingItem(const FObjectInitializer& ObjectInitializer);
	
	static bool bLoadedSettings;

	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="IdealTwinSettingItem")
	bool bSettingMarkDirty;
	
	UPROPERTY(BlueprintAssignable,Category="IdealTwinSettingItem")
	FOnSettingItemDirty OnSettingItemDirty;

	/* Apply changes when the value of the item. Warning: if it's enabled could have a high cost. Recommended use a general apply*/
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="IdealTwinSettingItem")
	bool bAutoApplyOnChange;
	/* Call the load settings from GameUserSettings on NativeOnInitialized process. Recommended use a general apply*/
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="IdealTwinSettingItem")
	bool bUseLoadSetting;

	static UGameUserSettings* GetGameUserSetting();

	UFUNCTION(BlueprintNativeEvent, Category="IdealTwinSettingItem")
	void LoadSetting();
	UFUNCTION(BlueprintNativeEvent, Category="IdealTwinSettingItem")
	void SaveSetting();
	


	
	UFUNCTION(BlueprintCallable,BlueprintNativeEvent, Category="IdealTwinSettingItem")
	void SetSetting();
	UFUNCTION(BlueprintCallable,BlueprintNativeEvent, Category="IdealTwinSettingItem")
	void ApplySetting();
	UFUNCTION(BlueprintCallable,BlueprintNativeEvent, Category="IdealTwinSettingItem")
	void RefreshSetting();

protected:
	virtual void NativeOnInitialized() override;
};
