// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "IdealTwinSettingItem.h"
#include "Components/CheckBox.h"
#include "UObject/Object.h"
#include "IdealTwinSettingToggle.generated.h"

UENUM(BlueprintType)
enum ESettingToggleType
{
	ESTT_FullScreen			UMETA(DisplayName = "Full Screen"),
	ESTT_VSync				UMETA(DisplayName = "VSync"),
};

UCLASS(Abstract)
class IDEALTWINPROUI_API UIdealTwinSettingToggle : public UIdealTwinSettingItem
{
	GENERATED_BODY()
public:
	UIdealTwinSettingToggle(const FObjectInitializer& ObjectInitializer);
	
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinSettingToggle", meta=(ExposeOnSpawn))
	TEnumAsByte<ESettingToggleType> SettingType;
	
	UPROPERTY(BlueprintReadOnly,meta=(BindWidget))
	TObjectPtr<UCheckBox> SettingWidget;

	virtual void LoadSetting_Implementation() override;
	virtual void RefreshSetting_Implementation() override;
	virtual void SetSetting_Implementation() override;
	virtual void ApplySetting_Implementation() override;
protected:
	virtual void NativeOnInitialized() override;
	virtual void NativeConstruct() override;

	UFUNCTION() void ReceivedSettingChange(bool bIsChecked);
};
