// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "IdealTwinCommon/HttpPetitionCommons/DataModels/IdealTwinUserDataModel.h"
#include "UObject/Object.h"
#include "ITwUserDataDisplay.generated.h"

/** User Widget to display the user data once the user is logged, or when you want to pick a specific data to display */
UCLASS(Abstract)
class IDEALTWINPROUI_API UITwUserDataDisplay : public UUserWidget
{
	GENERATED_BODY()
public:
	
	UFUNCTION(BlueprintPure, Category = "ITwUserDataDisplay")
	bool IsGuestUser()const;
	UFUNCTION(BlueprintPure, Category = "ITwUserDataDisplay")
	bool IsUserLogged()const;
	UFUNCTION(BlueprintPure, Category = "ITwUserDataDisplay")
	bool GetUserData(FLoginInfo& OutUserData);

	DECLARE_DYNAMIC_DELEGATE_TwoParams(FOnUserImageRequestFinished, bool, bSuccess,UObject*, Image);

	UFUNCTION(BlueprintCallable, Category = "ITwUserDataDisplay")
	void GetUserImage(FOnUserImageRequestFinished ReceivedUserImage);
	
	UFUNCTION(BlueprintImplementableEvent, Category = "ITwUserDataDisplay")
	void OnUserLogged(const FLoginInfo& UserInfo);
	UFUNCTION(BlueprintImplementableEvent, Category = "ITwUserDataDisplay")
	void OnUserLogout();
	
protected:
	virtual void NativePreConstruct() override;
	virtual void NativeConstruct() override;
	virtual void NativeOnInitialized() override;

	UFUNCTION() void Received_UserLogged(bool bSuccess, FLoginInfo LoginInfo);
	UFUNCTION() void Received_UserLogout();


	UFUNCTION() void Received_ImageUserSolver(const TArray<UTexture2D*>& Texture2Ds);

	
	FLoginInfo LastUserInfo;
	FOnUserImageRequestFinished InternalReceivedUserImage;
};
