// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "IdealTwinCommon/HttpPetitionCommons/DataModels/IdealTwinUserDataModel.h"
#include "UObject/Object.h"
#include "ITwUserLogin.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FOnLoginResult,bool,bSuccess,FLoginInfo,LoginInfo);

UCLASS(Abstract)
class IDEALTWINPROUI_API UITwUserLogin : public UUserWidget
{
	GENERATED_BODY()
public:
	UITwUserLogin(const FObjectInitializer& ObjectInitializer);

	UPROPERTY(BlueprintAssignable)
	FOnLoginResult OnLoginResult;
	
	UFUNCTION(BlueprintCallable, Category = "LoginUser")
	void RequestUserLogin(FString InUserName,FString InUserPassword);
	UFUNCTION(BlueprintCallable, Category = "LoginUser")
	void RequestGuestLogin();
	
	
	UFUNCTION(BlueprintImplementableEvent,Category="LoginUser")
	void OnLoginInProcess(bool bInProgress);	
	UFUNCTION(BlueprintImplementableEvent, Category = "LoginUser")
	void OnLoadRememberOptions(const FIdealTwinUserInformation& UserInfo);
	UFUNCTION(BlueprintImplementableEvent,Category="LoginUser")
	void OnReceivedLoginResult(bool bSuccessful, FLoginInfo UserLogInfo);	
	
	UFUNCTION(BlueprintCallable, Category = "LoginUser")
	void SetRememberMeOption(bool InChecked);

protected:
	UFUNCTION() void Received_LoginResult(bool bSuccessful, FLoginInfo UserLogInfo);
	virtual void NativeConstruct() override;
	
	void LoadUserDataSaved();
	bool bRememberMeOption;
};
