﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Components/Border.h"
#include "Style/IdealTwinStyleModels.h"
#include "ITwBorder.generated.h"

/**
 * 
 */
UCLASS()
class IDEALTWINPROUI_API UITwBorder : public UBorder
{
	GENERATED_BODY()

public:
	UITwBorder(const FObjectInitializer& ObjectInitializer);

	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinBorder")
	FIdealTwinColorHandler ColorID;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinBorder")
	FIdealTwinCornerStyle CornerStyle;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinBorder")
	FIdealTwinSizeOverride SizeOverride;
	
	UFUNCTION(BlueprintCallable, Category="IdealTwinBorder")
	void SetColorByHandler(const FIdealTwinColorHandler& InColor);
	
	
	UFUNCTION(BlueprintCallable, Category="IdealTwinBorder")
	void UpdateStyle();
	
	virtual void ReleaseSlateResources(bool bReleaseChildren) override;
	virtual void SynchronizeProperties() override;
#if WITH_EDITOR
	virtual const FText GetPaletteCategory() override;
#endif

protected:
	virtual TSharedRef<SWidget> RebuildWidget() override;
	
	TSharedPtr<SBox> SizeBox;
};
