// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Components/EditableText.h"
#include "Style/IdealTwinStyleModels.h"
#include "UObject/Object.h"
#include "ITwEditableText.generated.h"



UCLASS()
class IDEALTWINPROUI_API UITwEditableText : public UEditableText
{
	GENERATED_BODY()
public:
	UITwEditableText(const FObjectInitializer& ObjectInitializer);
	
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinText")
	FName FontStyle;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinText")
	FIdealTwinColorHandler ColorID;

	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void SetFontStyleFromName(FName NewStyle);

	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void SetColorByHandler(const FIdealTwinColorHandler& Color);
	
	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void UpdateStyle();

	virtual void SynchronizeProperties() override;
	
#if WITH_EDITOR
	virtual const FText GetPaletteCategory() override;
#endif
};
