﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Components/TextBlock.h"
#include "Style/IdealTwinStyleModels.h"
#include "UObject/Object.h"
#include "ITwFontIcon.generated.h"

/**
 * 
 */
UCLASS()
class IDEALTWINPROUI_API UITwFontIcon : public UTextBlock
{
	GENERATED_BODY()
public:
	UITwFontIcon(const FObjectInitializer& ObjectInitializer);
	
	
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ITwFontIcon")
	int32 IconSize;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ITwFontIcon")
	bool bUseContrast;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ITwFontIcon")
	FFontIconHandler IconStyling;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ITwFontIcon")
	FFontIconHandler IconContrast;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ITwFontIcon")
	FFontIconHandler IconHover;	
	
	FFontIconHandler& GetIconStyle();

	UFUNCTION(BlueprintCallable, Category="ITwFontIcon")
	void SetHover(bool bHover);
	UFUNCTION(BlueprintCallable, Category="ITwFontIcon")
	void SetContrast(bool bContrast);
	UFUNCTION(BlueprintCallable, Category="ITwFontIcon")
	void ToggleContras();
	
	UFUNCTION(BlueprintCallable, Category="ITwFontIcon")
	void SetIconSize(int32 NewSize);
	
	UFUNCTION(BlueprintCallable, Category="ITwFontIcon")
	void SetColorByHandler(const FIdealTwinColorHandler& Color);
	UFUNCTION(BlueprintCallable, Category="ITwFontIcon")
	void SetColorContrastByHandler(const FIdealTwinColorHandler& Color);
	
	UFUNCTION(BlueprintCallable, Category="ITwFontIcon")
	void SetIconByHandler(const FFontIconHandler& FontIcon);
	UFUNCTION(BlueprintCallable, Category="ITwFontIcon")
	void SetContrastIconByHandler(const FFontIconHandler& FontIcon);

	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void BindOnButtonSelectionContras(UITwButton* Button);

	
	void SetIconByName(const FName& InName);
	
	virtual void SynchronizeProperties() override;
#if WITH_EDITOR
	virtual void PostEditChangeProperty(FPropertyChangedEvent& PropertyChangedEvent) override;
	virtual const FText GetPaletteCategory() override;
#endif

protected:
	UFUNCTION() void ReceivedButtonChangeState(UITwButton* Button,bool bSelected);

	bool bUseHover;
};
