// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Components/Image.h"
#include "UObject/Object.h"
#include "IdealTwinCommon/IdealTwinUtilsCommon.h"
#include "Style/IdealTwinStyleModels.h"
#include "Widgets/Layout/SScaleBox.h"
#include "ITwImage.generated.h"


class SScaleBox;
class UIdealTwinImageDownloader;
struct FImageObjectData;


UENUM(BlueprintType) enum EImageDownloaderState
{
	EID_None				UMETA(DisplayName="None"),
	EID_Downloading			UMETA(DisplayName="Downloading"),
	EID_Downloaded			UMETA(DisplayName="Downloaded"),
	EID_FailedDownload		UMETA(DisplayName="Failed Download"),

};

DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnImageStateChanged, TEnumAsByte<EImageDownloaderState>, ImageState);
UCLASS()
class IDEALTWINPROUI_API UITwImage : public UImage
{
	GENERATED_BODY()

public:
	UITwImage(const FObjectInitializer& ObjectInitializer);

	UPROPERTY(BlueprintAssignable, Category="ImageDownloader")
	FOnImageStateChanged OnImageStateChanged;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="ImageDownloader")
	bool bMatchTexture;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="ImageDownloader", meta=( AllowPrivateAccess="true", DisplayThumbnail="true", DisplayName="Image", AllowedClasses="/Script/Engine.Texture,/Script/Engine.MaterialInterface,/Script/Engine.SlateTextureAtlasInterface", DisallowedClasses = "/Script/MediaAssets.MediaTexture"))
	TObjectPtr<UObject> DownloadingImage;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ImageDownloader")
	TObjectPtr<UTexture2D> AltImage;
	
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ImageDownloader")
	TEnumAsByte<EStretch::Type> Stretch;

	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ImageDownloader")
	FIdealTwinSizeOverride OverrideSize;
	
	UFUNCTION(BlueprintCallable, Category="ImageDownloader")
	void SetImageFromData(FImageObjectData ImageObjectData, TEnumAsByte<EImageRequestSize> SizeImage);

	virtual void ReleaseSlateResources(bool bReleaseChildren) override;
	virtual void SynchronizeProperties() override;
#if WITH_EDITOR
	virtual const FText GetPaletteCategory() override;
#endif	
protected:
	
	UFUNCTION() void ReceivedDownloadImage(FIdealTwinDownloadedImage DownloadedImage);
	virtual TSharedRef<SWidget> RebuildWidget() override;

	void SetChangeState(EImageDownloaderState ImageState) const;

private:
	TSharedPtr<SBox> SizeBox;
	TSharedPtr<SScaleBox> ScaleBox;
	UPROPERTY() TObjectPtr<UIdealTwinImageDownloader> ImageDownloader;
};
