﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Components/NamedSlot.h"
#include "ITwMovableArea.generated.h"

class SBox;
class SBorder;
class SOverlay;

DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnStartCaptureMouse);
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnStopCaptureMouse);

/**
 * UI Component created to be able to have a zone that moves across the screen as if it were a drag and drop but
 * instead of using that operation we use the translation of the widget so that it can be implemented anywhere in an independent way from the parent.
 * independent of the parent.
 * To use it you only have to add this widget and add a child and it will be able to move if you click on the specified area.
 */
UCLASS()
class IDEALTWINPROUI_API UITwMovableArea : public UNamedSlot
{
	GENERATED_BODY()
public:
	UITwMovableArea(const FObjectInitializer& ObjectInitializer);

	UPROPERTY(BlueprintAssignable, Category="ITwMovableArea")
	FOnStartCaptureMouse OnStartCaptureMouse;
	UPROPERTY(BlueprintAssignable, Category="ITwMovableArea")
	FOnStopCaptureMouse OnStopCaptureMouse;	
	
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="ITwMovableArea")
	float ClickableZoneHeight;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="ITwMovableArea")
	bool bOverlapZone;
	//flag that controls if we want to enable the border of the MovableArea.  
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="ITwMovableArea")
	bool bUseSelectableBorder; 
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="ITwMovableArea")
	FSlateBrush BrushHighlight;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="ITwMovableArea|Debug")
	bool bDebugArea;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="ITwMovableArea|Debug")
	bool bPreviewHighlight;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="ITwMovableArea|Debug")
	FSlateBrush BorderBrush;

	UFUNCTION(Blueprintable, Category="ITwMovableArea")
	void SetContentWidget(UWidget* InContent);
	
	UFUNCTION(Blueprintable, Category="ITwMovableArea")
	void RestorePosition();
	
	UFUNCTION(Blueprintable, Category="ITwMovableArea")
	void SetHighlight(bool Visible) const;
	
	virtual void SynchronizeProperties() override;
	virtual void ReleaseSlateResources(bool bReleaseChildren) override;
#if WITH_EDITOR
	virtual const FText GetPaletteCategory() override;
	virtual void PostEditChangeProperty(FPropertyChangedEvent& PropertyChangedEvent) override;
#endif
	
protected:
	virtual TSharedRef<SWidget> RebuildWidget() override;

	FReply HandleMouseDown(const FGeometry& Geometry, const FPointerEvent& Event);
	FReply HandleMouseUp(const FGeometry& Geometry, const FPointerEvent& Event);
	FReply HandleMouseMove(const FGeometry& Geometry, const FPointerEvent& Event);

	FVector2D GetMouseLocalPos(const FGeometry& Geometry) const;

	/*Returns the margin depending on whether the overlap and the height of the clickable area are used*/
	FMargin GetMarginOverlap()const;
	
private:
	bool bTrackMouse;
	FVector2D ClickOffset;

	
	TSharedPtr<SOverlay> Overlay;
	TSharedPtr<SBox> BoxSize;
	TSharedPtr<SBorder> BorderClickable;
	TSharedPtr<SBorder> BorderHighlight;
	SOverlay::FOverlaySlot* ContentOverlaySlot;
	SOverlay::FOverlaySlot* HighlightOverlaySlot;

};
