﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Components/TextBlock.h"
#include "Style/IdealTwinStyleModels.h"
#include "ITwText.generated.h"


class UITwButton;

UCLASS()
class IDEALTWINPROUI_API UITwText : public UTextBlock
{
	GENERATED_BODY()

public:
	UITwText(const FObjectInitializer& ObjectInitializer);
	
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinText")
	FName FontStyle;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinText")
	FIdealTwinColorHandler ColorText;

	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void SetContrast(bool bContrast);
	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void ToggleContrast();
	
	
	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void SetFontStyleFromName(FName NewStyle);
	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void SetColorByHandler(const FIdealTwinColorHandler& InColorHandler);
	
	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void UpdateStyle();

	UFUNCTION(BlueprintCallable, Category="IdealTwinText")
	void BindOnButtonSelectionContras(UITwButton* Button);

	virtual void ReleaseSlateResources(bool bReleaseChildren) override;
	virtual void SynchronizeProperties() override;

	
#if WITH_EDITOR
	virtual const FText GetPaletteCategory() override;
#endif


protected:
	UFUNCTION() void ReceivedButtonChangeState(UITwButton* Button,bool bSelected);

	bool bUseContrastColor;
};
